import cv2 
import numpy as np 
import matplotlib.pyplot as plt 
from skimage.segmentation import find_boundaries 
import math 
import time 
import os 

if __name__ == '__main__':
    folder = "Cellpose output for try"
    files = os.listdir(folder)
    outfold = "Texts"
    if not os.path.exists(outfold):
        os.makedirs(outfold)
    for file in files:
        start = time.time()
        img = cv2.imread(os.path.join(folder, file), 0) 
        # plt.imshow(img)
        # plt.show()
        # math.pi 
        # 4 *math.pi *i2.sum() / (i2b.sum()**2) 
        outfile = open("%s/%s.csv"%(outfold, file.split('.')[0]),'w')
        outfile.write("Number, Circularity, Area, Perimeter\n")
        bins = np.bincount(img.flatten())
        for i in range(bins.shape[0] -1):
            if bins[i+1] == 0:
                continue
            ia = (img==i+1).astype(np.uint8) 
            area = ia.sum()
            ip = find_boundaries(ia, mode='outer').astype(int) 
            peri = ip.sum()
            print(peri)
            # ip = find_boundaries(ia, mode='inner').astype(int) 
            # peri = ip.sum()
            # print(peri)
            # ip = find_boundaries(ia, mode='thick').astype(np.uint8) 
            # peri = ip.sum()
            # print(peri)
            contours, _ = cv2.findContours(ia, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)
            # print("Contours:", contours)
            if len(contours):
                p2 = cv2.arcLength(contours[0], True)
                circularity = 4*math.pi*area / p2**2 
                print("Number, Circularity, Area, Perimeter")
                print(i+1, circularity, area, p2) 
                outfile.write("%d,%f,%d,%d\n"%(i+1,circularity, area, p2))
        end = time.time()
        timegui = end-start
        outfile.write("Total time: %f\n"%timegui)
        print("Total time: %f\n"%timegui)

        outfile.close()
